within TestLibrary.Models.ModelContainer2;

package Model2

import Modelica.Math.log;
import Modelica.Math.log10;
import Modelica.Math.exp;

encapsulated type States = enumeration(
		S1,
		X1,
		S2,
		S3,
		S4,
		S5,
		X2,
		S6,
		X3,
		X4,
		X5,
		X6,
		S7,
		X7,
		S8,
		S9,
		S10);

encapsulated type Composites = enumeration(
	C1,
	C2);

encapsulated type Species = enumeration(
	SP1,
	SP2,
	SP3,
	SP4,
	SP5,
	SP6,
	SP7,
	SP8,
	SP9,
	SP10);

class SubModel1
	Real states[States];

	parameter Real S1 = 2.0;
	parameter Real X1 = 150.0;
	parameter Real S2 = 50.0;
	parameter Real S3 = 0.0;
	parameter Real S4 = 25.0;
	parameter Real S5 = 30.0;
	parameter Real X2 = 10.0;
	parameter Real S6 = 0.0;
	parameter Real	X3 = 10.0;
	parameter Real X4 = 160.0;
	parameter Real X5 = 20.0;
	parameter Real X6 = 0.0;
	parameter Real S7 = 16.0;
	parameter Real X7 = 50.0;
	parameter Real S8 = 0.005;
    parameter Real S9 = 0.005;
	parameter Real S10 = 0.005;


equation
	states[States.S1] = S1;
	states[States.X1] = X1;
	states[States.S2] = S2;
	states[States.S3] = S3;
	states[States.S4] = S4;
	states[States.S5] = S5;
	states[States.X2] = X2;
	states[States.S6] = S6;
	states[States.X3] = X3;
	states[States.X4] = X4;
	states[States.X5] = X5;
	states[States.X6] = X6;
	states[States.S7] = S7;
	states[States.X7] = X7;
	states[States.S8] = S8;
	states[States.S9] = S9;
	states[States.S10] = S10;

end SubModel1;

class Parameters
	parameter Real pa1 = 3;
	parameter Real pa2 = 0.03;
	parameter Real pa3 = 0.4;
	parameter Real pa4 = 6;
	parameter Real pa5 = 0.8;
	parameter Real pa6 = 20;
	parameter Real pa7 = 0.62;
	parameter Real pa8 = 0.2;
	parameter Real pa9 = 0.5;
	parameter Real pa10 = 0.05;
	parameter Real pa11 = 0.8;
	parameter Real pa12 = 0.15;
	parameter Real pa13 = 0.08;
	parameter Real pa14 = 0.4;
	parameter Real pa15 = 1;

	parameter Real pa16 = 0.67;
	parameter Real pa17 = 0.08;
	parameter Real pa18 = 0.24;
	parameter Real pa19 = 0.086;
	parameter Real pa20 = 0.06;
	parameter Real pa21 = 2.85714285714;
	parameter Real pa22 = -4.57142857143;
	parameter Real pa23 = -1.71428571429;
	parameter Real pa24 = 0.0714285714286;
	parameter Real pa25 = -0.0714285714286;
	parameter Real pa26 = 1.48;

	parameter Real T = 20.0;
end Parameters;

class SubModel2

	Real states[States];
	Parameters parameters;

	parameter Real S1_0 = 2.0;
	parameter Real X1_0 = 150.0;
	parameter Real S2_0 = 50.0;
	parameter Real S3_0 = 0.0;
	parameter Real S4_0 = 25.0;
	parameter Real S5_0 = 30.0;
	parameter Real X2_0 = 10.0;
	parameter Real S6_0 = 0.0;
	parameter Real	X3_0 = 10.0;
	parameter Real X4_0 = 160.0;
	parameter Real X5_0 = 20.0;
	parameter Real X6_0 = 0.0;
	parameter Real S7_0 = 16.0;
	parameter Real X7_0 = 50.0;
	parameter Real S8_0 = 0.01;
	parameter Real S9_0 = 0.01;
	parameter Real S10_0 = 0.003;


	type Processes = enumeration(
		r1,
		r2,
		r3,
		r4,
		r5,
		r6,
		r7,
		r8);

	Real var1[Processes, States];
	Real processRate[Processes];
	Real rate[States];

	Real var2;
	Real var3;
	Real var4;
	Real var5;
	Real var6;
	Real var7;
	Real var8;
	Real var9;

	constant States S1 = States.S1;
	constant States X1 = States.X1;
	constant States S2 = States.S2;
	constant States S3 = States.S3;
	constant States S4 = States.S4;
	constant States S5 = States.S5;
	constant States X2 = States.X2;
	constant States S6 = States.S6;
	constant States X3 = States.X3;
	constant States X4 = States.X4;
	constant States X5 = States.X5;
	constant States X6 = States.X6;
	constant States S7 = States.S7;
	constant States X7 = States.X7;
	constant States S8 = States.S8;
	constant States S9 = States.S9;
	constant States S10 = States.S10;

	constant Processes r1 = Processes.r1;
	constant Processes r2 = Processes.r2;
	constant Processes r3 = Processes.r3;
	constant Processes r4 = Processes.r4;
	constant Processes r5 = Processes.r5;
	constant Processes r6 = Processes.r6;
	constant Processes r7 = Processes.r7;
	constant Processes r8 = Processes.r8;

initial equation
	states[S1] = S1_0;
	states[X1] = X1_0;
	states[S2] = S2_0;
	states[S3] = S3_0;
	states[S4] = S4_0;
	states[S5] = S5_0;
	states[X2] = X2_0;
	states[S6] = S6_0;
	states[X3] = X3_0;
	states[X4] = X4_0;
	states[X5] = X5_0;
	states[X6] = X6_0;
	states[S7] = S7_0;
	states[X7] = X7_0;
	states[S8] = S8_0;
	states[S9] = S9_0;
	states[S10] = S10_0;


equation
	var1[r1, S5] = 0.0;
	var1[r1, S2] = -1/parameters.pa16;
	var1[r1, X1] = 0.0;
	var1[r1, X4] = 0.0;
	var1[r1, X5] = 1;
	var1[r1, X2] = 0.0;
	var1[r1, X6] = 0.0;
	var1[r1, S6] = -(1-parameters.pa16)/parameters.pa16;
	var1[r1, S3] = 0.0;
	var1[r1, S4] = -parameters.pa19;
	var1[r1, S1] = 0.0;
	var1[r1, X3] = 0.0;
	var1[r1, S7] = 0.0;
	var1[r1, X7] = 0.0;
	var1[r1, S8] = parameters.pa28*(1-parameters.pa16)/(parameters.pa27*1000*parameters.pa16);
	var1[r1, S9] = 0.0;
	var1[r1, S10] = 0.0;

	var1[r2, S5] = 0.0;
	var1[r2, S2] = -1/parameters.pa16;
	var1[r2, X1] = 0.0;
	var1[r2, X4] = 0.0;
	var1[r2, X5] = 1;
	var1[r2, X2] = 0.0;
	var1[r2, X6] = 0.0;
	var1[r2, S6] = 0.0;
	var1[r2, S3] = -(1-parameters.pa16)/(parameters.pa21*parameters.pa16);
	var1[r2, S4] = -parameters.pa19;
	var1[r2, S1] = 0.0;
	var1[r2, X3] = 0.0;
	var1[r2, S7] = (1-parameters.pa16)/(parameters.pa21*parameters.pa16);
	var1[r2, X7] = 0.0;
	var1[r2, S8] = parameters.pa28*(1-parameters.pa16)/(parameters.pa27*1000*parameters.pa16);
	var1[r2, S9] = 0.0;
	var1[r2, S10] = 0.0;

	var1[r3, S5] = 0.0;
	var1[r3, S2] = 0.0;
	var1[r3, X1] = 0.0;
	var1[r3, X4] = 0.0;
	var1[r3, X5] = 0.0;
	var1[r3, X2] = 1;
	var1[r3, X6] = 0.0;
	var1[r3, S6] = -(-parameters.pa22-parameters.pa18)/parameters.pa18;
	var1[r3, S3] = 1/parameters.pa18;
	var1[r3, S4] = -iparameters.XB-1/parameters.pa18;
	var1[r3, S1] = 0.0;
	var1[r3, X3] = 0.0;
	var1[r3, S7] = 0.0;
	var1[r3, X7] = 0.0;
	var1[r3, S8] = -parameters.pa28/(parameters.pa27*1000);
	var1[r3, S9] = 0.0;
	var1[r3, S10] = 0.0;

	var1[r4, S5] = 0.0;
	var1[r4, S2] = 0.0;
	var1[r4, X1] = 0.0;
	var1[r4, X4] = 1-parameters.pa17;
	var1[r4, X5] = -1;
	var1[r4, X2] = 0.0;
	var1[r4, X6] = parameters.pa17;
	var1[r4, S6] = 0.0;
	var1[r4, S3] = 0.0;
	var1[r4, S4] = 0.0;
	var1[r4, S1] = 0.0;
	var1[r4, X3] = parameters.pa19-parameters.pa17*parameters.pa20;
	var1[r4, S7] = 0.0;
	var1[r4, X7] = 0.0;
	var1[r4, S8] = 0.0;
	var1[r4, S9] = 0.0;
	var1[r4, S10] = 0.0;

	var1[r5, S5] = 0.0;
	var1[r5, S2] = 0.0;
	var1[r5, X1] = 0.0;
	var1[r5, X4] = 1-parameters.pa17;
	var1[r5, X5] = 0.0;
	var1[r5, X2] = -1;
	var1[r5, X6] = parameters.pa17;
	var1[r5, S6] = 0.0;
	var1[r5, S3] = 0.0;
	var1[r5, S4] = 0.0;
	var1[r5, S1] = 0.0;
	var1[r5, X3] = parameters.pa19-pa17*parameters.pa20;
	var1[r5, S7] = 0.0;
	var1[r5, X7] = 0.0;
	var1[r5, S8] = 0.0;
	var1[r5, S9] = 0.0;
	var1[r5, S10] = 0.0;

	var1[r6, S5] = 0.0;
	var1[r6, S2] = 0.0;
	var1[r6, X1] = 0.0;
	var1[r6, X4] = 0.0;
	var1[r6, X5] = 0.0;
	var1[r6, X2] = 0.0;
	var1[r6, X6] = 0.0;
	var1[r6, S6] = 0.0;
	var1[r6, S3] = 0.0;
	var1[r6, S4] = 1;
	var1[r6, S1] = -1;
	var1[r6, X3] = 0.0;
	var1[r6, S7] = 0.0;
	var1[r6, X7] = 0.0;
	var1[r6, S8] = 0.0;
	var1[r6, S9] = 0.0;
	var1[r6, S10] = 0.0;

	var1[r7, S5] = 0.0;
	var1[r7, S2] = 1;
	var1[r7, X1] = 0.0;
	var1[r7, X4] = -1;
	var1[r7, X5] = 0.0;
	var1[r7, X2] = 0.0;
	var1[r7, X6] = 0.0;
	var1[r7, S6] = 0.0;
	var1[r7, S3] = 0.0;
	var1[r7, S4] = 0.0;
	var1[r7, S1] = 0.0;
	var1[r7, X3] = 0.0;
	var1[r7, S7] = 0.0;
	var1[r7, X7] = 0.0;
	var1[r7, S8] = 0.0;
	var1[r7, S9] = 0.0;
	var1[r7, S10] = 0.0;

	var1[r8, S5] = 0.0;
	var1[r8, S2] = 0.0;
	var1[r8, X1] = 0.0;
	var1[r8, X4] = 0.0;
	var1[r8, X5] = 0.0;
	var1[r8, X2] = 0.0;
	var1[r8, X6] = 0.0;
	var1[r8, S6] = 0.0;
	var1[r8, S3] = 0.0;
	var1[r8, S4] = 0.0;
	var1[r8, S1] = 1;
	var1[r8, X3] = -1;
	var1[r8, S7] = 0.0;
	var1[r8, X7] = 0.0;
	var1[r8, S8] = 0.0;
	var1[r8, S9] = 0.0;
	var1[r8, S10] = 0.0;

	var2 = states[S2]/(parameters.pa6 + states[S2]);
	var3 = states[S6]/(parameters.pa8 + states[S6]);
	var4 = states[S6]/(parameters.pa14+states[S6]);
	var5 = states[S4]/(parameters.pa10 + states[S4]);
	var6 = states[S4]/(parameters.pa15 + states[S4]);
	var7 = states[S3]/(parameters.pa9+states[S3]);

	var9 = (states[X4]/states[X5])/(parameters.pa2+states[X4]/states[X5]);

	var8 = parameters.pa8/(parameters.pa8+states[S6]);

	processRate[r1] = parameters.pa4*var2*var3*var5*states[X5];
	processRate[r2] = parameters.pa4*var2*var8*var7*var5*parameters.pa5*states[X5];
	processRate[r3] = parameters.pa11*var6*var4*states[X2];
	processRate[r4] = parameters.pa7*states[X5];
	processRate[r5] = parameters.pa12*states[X2];
	processRate[r6] = parameters.pa13*states[S1]*states[X5];
	processRate[r7] = parameters.pa1*var9*(var3+parameters.pa3*var8*var7)*states[X5];
	processRate[r8] = parameters.pa1*(states[X3]/states[X4])*var9*var3+parameters.pa3*var8*var7*states[X5];

	rate[S5] = 0.0;
	rate[S2] =  + var1[r1, S2] * processRate[r1] + var1[r2, S2] * processRate[r2] + var1[r7, S2] * processRate[r7];
	rate[X1] = 0.0;
	rate[X4] =  + var1[r4, X4] * processRate[r4] + var1[r5, X4] * processRate[r5] + var1[r7, X4] * processRate[r7];
	rate[X5] =  + var1[r1, X5] * processRate[r1] + var1[r2, X5] * processRate[r2] + var1[r4, X5] * processRate[r4];
	rate[X2] =  + var1[r3, X2] * processRate[r3] + var1[r5, X2] * processRate[r5];
	rate[X6] =  + var1[r4, X6] * processRate[r4] + var1[r5, X6] * processRate[r5];
	rate[S6] =  + var1[r1, S6] * processRate[r1] + var1[r3, S6] * processRate[r3];
	rate[S3] =  + var1[r2, S3] * processRate[r2] + var1[r3, S3] * processRate[r3];
	rate[S4] =  + var1[r1, S4] * processRate[r1] + var1[r2, S4] * processRate[r2] + var1[r3, S4] * processRate[r3] + var1[r6, S4] * processRate[r6];
	rate[S1] =  + var1[r6, S1] * processRate[r6] + var1[r8, S1] * processRate[r8];
	rate[X3] =  + var1[r4, X3] * processRate[r4] + var1[r5, X3] * processRate[r5] + var1[r8, X3] * processRate[r8];
	rate[S7] =  + var1[r2, S7] * processRate[r2];
	rate[X7] = 0.0;
	rate[S8] = var1[r1, S8] * processRate[r1] + var1[r2, S8] * processRate[r2] + var1[r3, S8] * processRate[r3];
	rate[S9] = 0.0;
	rate[S10] = 0.0;

end SubModel2;

class SubModel3
	Parameters parameters;
	Real states[States];
	Real composites[Composites];

	constant States S1 = States.S1;
	constant States X1 = States.X1;
	constant States S2 = States.S2;
	constant States S3 = States.S3;
	constant States S4 = States.S4;
	constant States S5 = States.S5;
	constant States X2 = States.X2;
	constant States S6 = States.S6;
	constant States X3 = States.X3;
	constant States X4 = States.X4;
	constant States X5 = States.X5;
	constant States X6 = States.X6;
	constant States S7 = States.S7;
	constant States X7 = States.X7;
	constant States S8 = States.S8;
	constant States S9 = States.S9;
	constant States S10 = States.S10;


	constant Composites C1 = Composites.C1;
	constant Composites C2 = Composites.C2;

equation
	composites[C1] = states[X1] + states[S2] + states[S5] + states[X2] + states[X4] + states[X5] + states[X6];
	composites[C2] = states[S2] + states[X2] + states[X4] + states[X5];
end SubModel3;

class SubModel4
	Parameters parameters;
	Real states[States];
	Real species[Species];

	Real var68;
	Real var74;
	Real var50;
	Real var51;
	Real var69;
	Real var70;
	Real var52;
	Real var53;
	Real var54;

	Real var55;
	Real var56;
	Real var57;

	Real var58;
	Real var59;
	Real var60;
	Real var61;
	Real var72;
	Real var71;
	Real var76;
	Real var75;

	Real var73;
	Real var62;

	constant Species SP1 = Species.SP1;
	constant Species SP2 = Species.SP2;
	constant Species SP3 = Species.SP3;
	constant Species SP4 = Species.SP4;
	constant Species SP5 = Species.SP5;
	constant Species SP6 = Species.SP6;
	constant Species SP7 = Species.SP7;
	constant Species SP8 = Species.SP8;
	constant Species SP9 = Species.SP9;
	constant Species SP10 = Species.SP10;

	constant States S1 = States.S1;
	constant States X1 = States.X1;
	constant States S2 = States.S2;
	constant States S3 = States.S3;
	constant States S4 = States.S4;
	constant States S5 = States.S5;
	constant States X2 = States.X2;
	constant States S6 = States.S6;
	constant States X3 = States.X3;
	constant States X4 = States.X4;
	constant States X5 = States.X5;
	constant States X6 = States.X6;
	constant States S7 = States.S7;
	constant States X7 = States.X7;
	constant States S8 = States.S8;
	constant States S9 = States.S9;
	constant States S10 = States.S10;


	constant Real var63 = 6.867e-15;
	constant Real var65 = -285.84;
	constant Real var66 = -229.994;
	constant Real var67 = -286.93308;
	constant Real var64 = 298.15;
	constant Real R = 8.314;

equation
	var68 = -log10(species[SP1]);
    species[SP2] = var74/species[SP1];
    species[SP3] = (states[S4]/14000)*var51/(species[SP1]+var51);
    species[SP4] = (states[S4]/14000)*species[SP1]/(species[SP1]+var51);
    species[SP5] = states[S3]/14000;
    species[SP6] = states[S8]*species[SP1]^2/(species[SP1]^2+species[SP1]*var69+var69*var70);
	species[SP7] = species[SP1]*var69*states[S8]/(species[SP1]^2+species[SP1]*var69+var69*var70);
	species[SP8] = var70*var69*states[S8]/(species[SP1]^2+species[SP1]*var69+var69*var70);
	species[SP9] = states[S9];
	species[SP10] = states[S10];

	var61 = min(var72, 0.3);
	var72 = 0.5*((+1)^2*species[SP1]    +
	          (-1)^2*species[SP2]   +
	           (0)^2*species[SP3]    +
	          (+1)^2*species[SP4]  +
	          (-1)^2*species[SP5]  +
	           (0)^2*species[SP6]  +
	          (-1)^2*species[SP7] +
	          (-2)^2*species[SP8] +
	          (+1)^2*species[SP9]  +
	          (-1)^2*species[SP10]);

	var71 = var75 - var76;

	var75 = (+1)*species[SP1]   +
	                 (+1)*species[SP4] +
	                 (+1)*species[SP9];

	var76 = (-1)*species[SP2]   +
	                (-1)*species[SP5]  +
	                (-1)*species[SP7] +
	                (-2)*species[SP8] +
	                (-1)*species[SP10];

	var76 = var75;

	var55 = 10^(-var58*1^(2)*(var61^(0.5)/(1+1.5*var61^(0.5))-0.3*var61));
	var56 = 10^(-var58*2^(2)*(var61^(0.5)/(1+1.5*var61^(0.5))-0.3*var61));
	var57 = 10^(-var58*3^(2)*(var61^(0.5)/(1+1.5*var61^(0.5))-0.3*var61));

	var58 = 1.82483*10^6*var59^(0.5)*(var60*var73)^(-1.5);
	var60 = 2727.586+0.6224107*var73-466.9151*log(var73)-(52000.87/var73);
	var73 = parameters.T + 273.16;
	var59 = 1-(parameters.T-3.9863)^2*(parameters.T+288.9414)/(508929.2*(parameters.T+68.12963))+0.011445*exp(-374.3/parameters.T);

	var74 = var50/var55^2;
	var50 = var63*exp(var54/R*(1/var64-1/var73));
	var54 = (var66+var65) - 2*var67;

	var69 = var52/var55^2;
	var70 = var53/var56;

	var52 = 10^(-(3404.7/var73-14.8435+var73*0.03279));
	var53 = 10^(-(2902.4/var73-6.498+var73*0.02379));

	var51 = 10^(-(2835.8/var73 - 0.6322 + 0.00123*var73));

	var62 = species[SP2]   +
	       species[SP3]    +
	       species[SP7] +
	       2*species[SP8] -
	       species[SP1];


end SubModel4;

connector SubModel5
	flow Real Q;
	Real states[States];
	Real composites[Composites];
	Real species[Species];
end SubModel5;

end Model2;

